unit StoperImpl1;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, ActiveX, Classes, Controls, Graphics, Menus, Forms, StdCtrls,
  ComServ, StdVCL, AXCtrls, StoperXControl1_TLB, stoper;

type
  TStoperX = class(TActiveXControl, IStoperX)
  private
    { Private declarations }
    FDelphiControl: TStoper;
    FEvents: IStoperXEvents;
    procedure ClickEvent(Sender: TObject);
    procedure KeyPressEvent(Sender: TObject; var Key: Char);
    procedure ResetEvent(Sender: TObject);
    procedure StartEvent(Sender: TObject);
    procedure StopEvent(Sender: TObject);
  protected
    { Protected declarations }
    procedure DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage); override;
    procedure EventSinkChanged(const EventSink: IUnknown); override;
    procedure InitializeControl; override;
    function DrawTextBiDiModeFlagsReadingOnly: Integer; safecall;
    function Get_AlignDisabled: WordBool; safecall;
    function Get_Cancel: WordBool; safecall;
    function Get_Caption: WideString; safecall;
    function Get_Default: WordBool; safecall;
    function Get_DoubleBuffered: WordBool; safecall;
    function Get_DragCursor: Smallint; safecall;
    function Get_DragMode: TxDragMode; safecall;
    function Get_Enabled: WordBool; safecall;
    function Get_Font: IFontDisp; safecall;
    function Get_Visible: WordBool; safecall;
    function Get_VisibleDockClientCount: Integer; safecall;
    function Get_WordWrap: WordBool; safecall;
    function IsRightToLeft: WordBool; safecall;
    function UseRightToLeftReading: WordBool; safecall;
    function UseRightToLeftScrollBar: WordBool; safecall;
    procedure _Set_Font(var Value: IFontDisp); safecall;
    procedure AboutBox; safecall;
    procedure InitiateAction; safecall;
    procedure Set_Cancel(Value: WordBool); safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    procedure Set_Default(Value: WordBool); safecall;
    procedure Set_DoubleBuffered(Value: WordBool); safecall;
    procedure Set_DragCursor(Value: Smallint); safecall;
    procedure Set_DragMode(Value: TxDragMode); safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    procedure Set_Font(const Value: IFontDisp); safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    procedure Set_WordWrap(Value: WordBool); safecall;
    procedure SetSubComponent(IsSubComponent: WordBool); safecall;
  end;

implementation

uses ComObj, About1;

{ TStoperX }

procedure TStoperX.DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage);
begin
  {TODO: Define property pages here.  Property pages are defined by calling
    DefinePropertyPage with the class id of the page.  For example,
      DefinePropertyPage(Class_StoperXPage); }
end;

procedure TStoperX.EventSinkChanged(const EventSink: IUnknown);
begin
  FEvents := EventSink as IStoperXEvents;
end;

procedure TStoperX.InitializeControl;
begin
  FDelphiControl := Control as TStoper;
  //FDelphiControl.OnClick := ClickEvent;
  //FDelphiControl.OnKeyPress := KeyPressEvent;
  FDelphiControl.OnReset := ResetEvent;
  FDelphiControl.OnStart := StartEvent;
  FDelphiControl.OnStop := StopEvent;
end;

function TStoperX.DrawTextBiDiModeFlagsReadingOnly: Integer;
begin
  Result := FDelphiControl.DrawTextBiDiModeFlagsReadingOnly;
end;

function TStoperX.Get_AlignDisabled: WordBool;
begin
  Result := FDelphiControl.AlignDisabled;
end;

function TStoperX.Get_Cancel: WordBool;
begin
  Result := FDelphiControl.Cancel;
end;

function TStoperX.Get_Caption: WideString;
begin
  Result := WideString(FDelphiControl.Caption);
end;

function TStoperX.Get_Default: WordBool;
begin
  Result := FDelphiControl.Default;
end;

function TStoperX.Get_DoubleBuffered: WordBool;
begin
  Result := FDelphiControl.DoubleBuffered;
end;

function TStoperX.Get_DragCursor: Smallint;
begin
  Result := Smallint(FDelphiControl.DragCursor);
end;

function TStoperX.Get_DragMode: TxDragMode;
begin
  Result := Ord(FDelphiControl.DragMode);
end;

function TStoperX.Get_Enabled: WordBool;
begin
  Result := FDelphiControl.Enabled;
end;

function TStoperX.Get_Font: IFontDisp;
begin
  GetOleFont(FDelphiControl.Font, Result);
end;

function TStoperX.Get_Visible: WordBool;
begin
  Result := FDelphiControl.Visible;
end;

function TStoperX.Get_VisibleDockClientCount: Integer;
begin
  Result := FDelphiControl.VisibleDockClientCount;
end;

function TStoperX.Get_WordWrap: WordBool;
begin
  Result := FDelphiControl.WordWrap;
end;

function TStoperX.IsRightToLeft: WordBool;
begin
  Result := FDelphiControl.IsRightToLeft;
end;

function TStoperX.UseRightToLeftReading: WordBool;
begin
  Result := FDelphiControl.UseRightToLeftReading;
end;

function TStoperX.UseRightToLeftScrollBar: WordBool;
begin
  Result := FDelphiControl.UseRightToLeftScrollBar;
end;

procedure TStoperX._Set_Font(var Value: IFontDisp);
begin
  SetOleFont(FDelphiControl.Font, Value);
end;

procedure TStoperX.AboutBox;
begin
  ShowStoperXAbout;
end;

procedure TStoperX.ClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnClick;
end;

procedure TStoperX.InitiateAction;
begin
  FDelphiControl.InitiateAction;
end;

procedure TStoperX.KeyPressEvent(Sender: TObject; var Key: Char);
var
  TempKey: Smallint;
begin
  TempKey := Smallint(Key);
  if FEvents <> nil then FEvents.OnKeyPress(TempKey);
  Key := Char(TempKey);
end;

procedure TStoperX.ResetEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnReset;
end;

procedure TStoperX.Set_Cancel(Value: WordBool);
begin
  FDelphiControl.Cancel := Value;
end;

procedure TStoperX.Set_Caption(const Value: WideString);
begin
  FDelphiControl.Caption := TCaption(Value);
end;

procedure TStoperX.Set_Default(Value: WordBool);
begin
  FDelphiControl.Default := Value;
end;

procedure TStoperX.Set_DoubleBuffered(Value: WordBool);
begin
  FDelphiControl.DoubleBuffered := Value;
end;

procedure TStoperX.Set_DragCursor(Value: Smallint);
begin
  FDelphiControl.DragCursor := TCursor(Value);
end;

procedure TStoperX.Set_DragMode(Value: TxDragMode);
begin
  FDelphiControl.DragMode := TDragMode(Value);
end;

procedure TStoperX.Set_Enabled(Value: WordBool);
begin
  FDelphiControl.Enabled := Value;
end;

procedure TStoperX.Set_Font(const Value: IFontDisp);
begin
  SetOleFont(FDelphiControl.Font, Value);
end;

procedure TStoperX.Set_Visible(Value: WordBool);
begin
  FDelphiControl.Visible := Value;
end;

procedure TStoperX.Set_WordWrap(Value: WordBool);
begin
  FDelphiControl.WordWrap := Value;
end;

procedure TStoperX.SetSubComponent(IsSubComponent: WordBool);
begin
  FDelphiControl.SetSubComponent(IsSubComponent);
end;

procedure TStoperX.StartEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnStart;
end;

procedure TStoperX.StopEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnStop;
end;

initialization
  TActiveXControlFactory.Create(
    ComServer,
    TStoperX,
    TStoper,
    Class_StoperX,
    1,
    '',
    0,
    tmApartment);
end.
